/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.stream;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import org.apache.camel.util.StringHelper;

public class CipherPair {
    private final String transformation;
    private final Cipher enccipher;
    private final Key key;
    private final byte[] ivp;

    public CipherPair(String transformation) throws GeneralSecurityException {
        this.transformation = transformation;
        String a = StringHelper.before((String)transformation, (String)"/", (String)transformation);
        KeyGenerator keygen = KeyGenerator.getInstance(a);
        keygen.init(new SecureRandom());
        this.key = keygen.generateKey();
        this.enccipher = Cipher.getInstance(transformation);
        this.enccipher.init(1, this.key);
        this.ivp = this.enccipher.getIV();
    }

    public String getTransformation() {
        return this.transformation;
    }

    public Cipher getEncryptor() {
        return this.enccipher;
    }

    public Cipher createDecryptor() {
        try {
            Cipher deccipher = Cipher.getInstance(this.transformation);
            deccipher.init(2, this.key, this.ivp == null ? null : new IvParameterSpec(this.ivp));
            return deccipher;
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("Could not instanciate decryptor", e);
        }
    }
}

