/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.concurrent.JMXEnabledThreadPoolExecutor;
import org.apache.cassandra.concurrent.NamedThreadFactory;

public class JMXEnabledSingleThreadExecutor
extends JMXEnabledThreadPoolExecutor {
    public JMXEnabledSingleThreadExecutor(String threadPoolName, String jmxPath) {
        super(1, Integer.MAX_VALUE, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new SingleThreadFactory(threadPoolName), jmxPath);
    }

    @Override
    public void setCoreThreads(int number) {
        throw new UnsupportedOperationException("Cannot change core pool size for single threaded executor.");
    }

    @Override
    public void setMaximumThreads(int number) {
        throw new UnsupportedOperationException("Cannot change max threads for single threaded executor.");
    }

    @Override
    public void setMaximumPoolSize(int newMaximumPoolSize) {
        this.setMaximumThreads(newMaximumPoolSize);
    }

    public boolean isExecutedBy(Thread test) {
        return this.getThreadFactory().thread == test;
    }

    @Override
    public SingleThreadFactory getThreadFactory() {
        return (SingleThreadFactory)super.getThreadFactory();
    }

    @Override
    public void setThreadFactory(ThreadFactory threadFactory) {
        throw new UnsupportedOperationException();
    }

    private static class SingleThreadFactory
    extends NamedThreadFactory {
        private volatile Thread thread;

        SingleThreadFactory(String id) {
            super(id);
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread;
            this.thread = thread = super.newThread(r);
            return thread;
        }
    }
}

