/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.collateralmanagement.domain;

import java.util.List;
import org.apache.fineract.portfolio.collateral.exception.CollateralNotFoundException;
import org.apache.fineract.portfolio.collateralmanagement.domain.CollateralManagementDomain;
import org.apache.fineract.portfolio.collateralmanagement.domain.CollateralManagementDomainRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CollateralManagementRepositoryWrapper {
    private final CollateralManagementDomainRepository collateralManagementDomainRepository;

    @Autowired
    public CollateralManagementRepositoryWrapper(CollateralManagementDomainRepository collateralManagementDomainRepository) {
        this.collateralManagementDomainRepository = collateralManagementDomainRepository;
    }

    public CollateralManagementDomain create(CollateralManagementDomain collateralData) {
        return (CollateralManagementDomain)this.collateralManagementDomainRepository.saveAndFlush((Object)collateralData);
    }

    public CollateralManagementDomain getCollateral(Long collateralId) {
        return (CollateralManagementDomain)this.collateralManagementDomainRepository.findById((Object)collateralId).orElseThrow(() -> new CollateralNotFoundException(collateralId));
    }

    public List<CollateralManagementDomain> getAllCollaterals() {
        return this.collateralManagementDomainRepository.findAll();
    }

    public CollateralManagementDomain update(CollateralManagementDomain collateralManagementData) {
        return (CollateralManagementDomain)this.collateralManagementDomainRepository.saveAndFlush((Object)collateralManagementData);
    }

    public void delete(Long collateralId) {
        this.collateralManagementDomainRepository.deleteById((Object)collateralId);
    }
}

