/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.jobs.payduesavingscharges;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.infrastructure.jobs.exception.JobExecutionException;
import org.apache.fineract.portfolio.savings.data.SavingsAccountAnnualFeeData;
import org.apache.fineract.portfolio.savings.service.SavingsAccountChargeReadPlatformService;
import org.apache.fineract.portfolio.savings.service.SavingsAccountWritePlatformService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;

public class PayDueSavingsChargesTasklet
implements Tasklet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PayDueSavingsChargesTasklet.class);
    private final SavingsAccountChargeReadPlatformService savingsAccountChargeReadPlatformService;
    private final SavingsAccountWritePlatformService savingsAccountWritePlatformService;

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        Collection chargesDueData = this.savingsAccountChargeReadPlatformService.retrieveChargesWithDue();
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        for (SavingsAccountAnnualFeeData savingsAccountReference : chargesDueData) {
            try {
                this.savingsAccountWritePlatformService.applyChargeDue(savingsAccountReference.getId(), savingsAccountReference.getAccountId());
            }
            catch (PlatformApiDataValidationException e) {
                exceptions.add(e);
                List errors = e.getErrors();
                for (ApiParameterError error : errors) {
                    log.error("Apply Charges due for savings failed for account {} with message: {}", new Object[]{savingsAccountReference.getAccountNo(), error.getDeveloperMessage(), e});
                }
            }
            catch (Exception ex) {
                exceptions.add(ex);
                log.error("Apply Charges due for savings failed for account: {}", (Object)savingsAccountReference.getAccountNo(), (Object)ex);
            }
        }
        log.debug("{}: Records affected by applyDueChargesForSavings: {}", (Object)ThreadLocalContextUtil.getTenant().getName(), (Object)chargesDueData.size());
        if (!exceptions.isEmpty()) {
            throw new JobExecutionException(exceptions);
        }
        return RepeatStatus.FINISHED;
    }

    @Generated
    public PayDueSavingsChargesTasklet(SavingsAccountChargeReadPlatformService savingsAccountChargeReadPlatformService, SavingsAccountWritePlatformService savingsAccountWritePlatformService) {
        this.savingsAccountChargeReadPlatformService = savingsAccountChargeReadPlatformService;
        this.savingsAccountWritePlatformService = savingsAccountWritePlatformService;
    }
}

