/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.system.progress;

import java.io.PrintStream;
import java.util.Objects;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.system.progress.MonitorOutput;
import org.slf4j.Logger;

public class MonitorOutputs {
    public static MonitorOutput nullOutput() {
        return (x, y) -> {};
    }

    public static MonitorOutput outputToLog(Logger logger) {
        Objects.requireNonNull(logger);
        return (fmt, args) -> {
            if (logger.isInfoEnabled()) {
                FmtLog.info((Logger)logger, (String)fmt, (Object[])args);
            }
        };
    }

    public static MonitorOutput outputTo(PrintStream output) {
        Objects.requireNonNull(output);
        return (fmt, args) -> {
            if (fmt.endsWith("\n") || fmt.endsWith("\r")) {
                output.print(String.format(fmt, args));
            } else {
                output.println(String.format(fmt, args));
            }
        };
    }
}

