# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .._utils import serialization as _serialization

if TYPE_CHECKING:
    from .. import models as _models


class AzureBlobDefinition(_serialization.Model):
    """Parameters to reconcile to the AzureBlob source kind type.

    :ivar url: The URL to sync for the flux configuration Azure Blob storage account.
    :vartype url: str
    :ivar container_name: The Azure Blob container name to sync from the url endpoint for the flux
     configuration.
    :vartype container_name: str
    :ivar timeout_in_seconds: The maximum time to attempt to reconcile the cluster Azure Blob
     source with the remote.
    :vartype timeout_in_seconds: int
    :ivar sync_interval_in_seconds: The interval at which to re-reconcile the cluster Azure Blob
     source with the remote.
    :vartype sync_interval_in_seconds: int
    :ivar service_principal: Parameters to authenticate using Service Principal.
    :vartype service_principal:
     ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.ServicePrincipalDefinition
    :ivar account_key: The account key (shared key) to access the storage account.
    :vartype account_key: str
    :ivar sas_token: The Shared Access token to access the storage container.
    :vartype sas_token: str
    :ivar managed_identity: Parameters to authenticate using a Managed Identity.
    :vartype managed_identity:
     ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.ManagedIdentityDefinition
    :ivar local_auth_ref: Name of a local secret on the Kubernetes cluster to use as the
     authentication secret rather than the managed or user-provided configuration secrets.
    :vartype local_auth_ref: str
    """

    _attribute_map = {
        "url": {"key": "url", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "timeout_in_seconds": {"key": "timeoutInSeconds", "type": "int"},
        "sync_interval_in_seconds": {"key": "syncIntervalInSeconds", "type": "int"},
        "service_principal": {"key": "servicePrincipal", "type": "ServicePrincipalDefinition"},
        "account_key": {"key": "accountKey", "type": "str"},
        "sas_token": {"key": "sasToken", "type": "str"},
        "managed_identity": {"key": "managedIdentity", "type": "ManagedIdentityDefinition"},
        "local_auth_ref": {"key": "localAuthRef", "type": "str"},
    }

    def __init__(
        self,
        *,
        url: Optional[str] = None,
        container_name: Optional[str] = None,
        timeout_in_seconds: int = 600,
        sync_interval_in_seconds: int = 600,
        service_principal: Optional["_models.ServicePrincipalDefinition"] = None,
        account_key: Optional[str] = None,
        sas_token: Optional[str] = None,
        managed_identity: Optional["_models.ManagedIdentityDefinition"] = None,
        local_auth_ref: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword url: The URL to sync for the flux configuration Azure Blob storage account.
        :paramtype url: str
        :keyword container_name: The Azure Blob container name to sync from the url endpoint for the
         flux configuration.
        :paramtype container_name: str
        :keyword timeout_in_seconds: The maximum time to attempt to reconcile the cluster Azure Blob
         source with the remote.
        :paramtype timeout_in_seconds: int
        :keyword sync_interval_in_seconds: The interval at which to re-reconcile the cluster Azure Blob
         source with the remote.
        :paramtype sync_interval_in_seconds: int
        :keyword service_principal: Parameters to authenticate using Service Principal.
        :paramtype service_principal:
         ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.ServicePrincipalDefinition
        :keyword account_key: The account key (shared key) to access the storage account.
        :paramtype account_key: str
        :keyword sas_token: The Shared Access token to access the storage container.
        :paramtype sas_token: str
        :keyword managed_identity: Parameters to authenticate using a Managed Identity.
        :paramtype managed_identity:
         ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.ManagedIdentityDefinition
        :keyword local_auth_ref: Name of a local secret on the Kubernetes cluster to use as the
         authentication secret rather than the managed or user-provided configuration secrets.
        :paramtype local_auth_ref: str
        """
        super().__init__(**kwargs)
        self.url = url
        self.container_name = container_name
        self.timeout_in_seconds = timeout_in_seconds
        self.sync_interval_in_seconds = sync_interval_in_seconds
        self.service_principal = service_principal
        self.account_key = account_key
        self.sas_token = sas_token
        self.managed_identity = managed_identity
        self.local_auth_ref = local_auth_ref


class AzureBlobPatchDefinition(_serialization.Model):
    """Parameters to reconcile to the AzureBlob source kind type.

    :ivar url: The URL to sync for the flux configuration Azure Blob storage account.
    :vartype url: str
    :ivar container_name: The Azure Blob container name to sync from the url endpoint for the flux
     configuration.
    :vartype container_name: str
    :ivar timeout_in_seconds: The maximum time to attempt to reconcile the cluster Azure Blob
     source with the remote.
    :vartype timeout_in_seconds: int
    :ivar sync_interval_in_seconds: The interval at which to re-reconcile the cluster Azure Blob
     source with the remote.
    :vartype sync_interval_in_seconds: int
    :ivar service_principal: Parameters to authenticate using Service Principal.
    :vartype service_principal:
     ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.ServicePrincipalPatchDefinition
    :ivar account_key: The account key (shared key) to access the storage account.
    :vartype account_key: str
    :ivar sas_token: The Shared Access token to access the storage container.
    :vartype sas_token: str
    :ivar managed_identity: Parameters to authenticate using a Managed Identity.
    :vartype managed_identity:
     ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.ManagedIdentityPatchDefinition
    :ivar local_auth_ref: Name of a local secret on the Kubernetes cluster to use as the
     authentication secret rather than the managed or user-provided configuration secrets.
    :vartype local_auth_ref: str
    """

    _attribute_map = {
        "url": {"key": "url", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "timeout_in_seconds": {"key": "timeoutInSeconds", "type": "int"},
        "sync_interval_in_seconds": {"key": "syncIntervalInSeconds", "type": "int"},
        "service_principal": {"key": "servicePrincipal", "type": "ServicePrincipalPatchDefinition"},
        "account_key": {"key": "accountKey", "type": "str"},
        "sas_token": {"key": "sasToken", "type": "str"},
        "managed_identity": {"key": "managedIdentity", "type": "ManagedIdentityPatchDefinition"},
        "local_auth_ref": {"key": "localAuthRef", "type": "str"},
    }

    def __init__(
        self,
        *,
        url: Optional[str] = None,
        container_name: Optional[str] = None,
        timeout_in_seconds: Optional[int] = None,
        sync_interval_in_seconds: Optional[int] = None,
        service_principal: Optional["_models.ServicePrincipalPatchDefinition"] = None,
        account_key: Optional[str] = None,
        sas_token: Optional[str] = None,
        managed_identity: Optional["_models.ManagedIdentityPatchDefinition"] = None,
        local_auth_ref: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword url: The URL to sync for the flux configuration Azure Blob storage account.
        :paramtype url: str
        :keyword container_name: The Azure Blob container name to sync from the url endpoint for the
         flux configuration.
        :paramtype container_name: str
        :keyword timeout_in_seconds: The maximum time to attempt to reconcile the cluster Azure Blob
         source with the remote.
        :paramtype timeout_in_seconds: int
        :keyword sync_interval_in_seconds: The interval at which to re-reconcile the cluster Azure Blob
         source with the remote.
        :paramtype sync_interval_in_seconds: int
        :keyword service_principal: Parameters to authenticate using Service Principal.
        :paramtype service_principal:
         ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.ServicePrincipalPatchDefinition
        :keyword account_key: The account key (shared key) to access the storage account.
        :paramtype account_key: str
        :keyword sas_token: The Shared Access token to access the storage container.
        :paramtype sas_token: str
        :keyword managed_identity: Parameters to authenticate using a Managed Identity.
        :paramtype managed_identity:
         ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.ManagedIdentityPatchDefinition
        :keyword local_auth_ref: Name of a local secret on the Kubernetes cluster to use as the
         authentication secret rather than the managed or user-provided configuration secrets.
        :paramtype local_auth_ref: str
        """
        super().__init__(**kwargs)
        self.url = url
        self.container_name = container_name
        self.timeout_in_seconds = timeout_in_seconds
        self.sync_interval_in_seconds = sync_interval_in_seconds
        self.service_principal = service_principal
        self.account_key = account_key
        self.sas_token = sas_token
        self.managed_identity = managed_identity
        self.local_auth_ref = local_auth_ref


class BucketDefinition(_serialization.Model):
    """Parameters to reconcile to the Bucket source kind type.

    :ivar url: The URL to sync for the flux configuration S3 bucket.
    :vartype url: str
    :ivar bucket_name: The bucket name to sync from the url endpoint for the flux configuration.
    :vartype bucket_name: str
    :ivar insecure: Specify whether to use insecure communication when puling data from the S3
     bucket.
    :vartype insecure: bool
    :ivar timeout_in_seconds: The maximum time to attempt to reconcile the cluster bucket source
     with the remote.
    :vartype timeout_in_seconds: int
    :ivar sync_interval_in_seconds: The interval at which to re-reconcile the cluster bucket source
     with the remote.
    :vartype sync_interval_in_seconds: int
    :ivar access_key: Plaintext access key used to securely access the S3 bucket.
    :vartype access_key: str
    :ivar local_auth_ref: Name of a local secret on the Kubernetes cluster to use as the
     authentication secret rather than the managed or user-provided configuration secrets.
    :vartype local_auth_ref: str
    """

    _attribute_map = {
        "url": {"key": "url", "type": "str"},
        "bucket_name": {"key": "bucketName", "type": "str"},
        "insecure": {"key": "insecure", "type": "bool"},
        "timeout_in_seconds": {"key": "timeoutInSeconds", "type": "int"},
        "sync_interval_in_seconds": {"key": "syncIntervalInSeconds", "type": "int"},
        "access_key": {"key": "accessKey", "type": "str"},
        "local_auth_ref": {"key": "localAuthRef", "type": "str"},
    }

    def __init__(
        self,
        *,
        url: Optional[str] = None,
        bucket_name: Optional[str] = None,
        insecure: bool = True,
        timeout_in_seconds: int = 600,
        sync_interval_in_seconds: int = 600,
        access_key: Optional[str] = None,
        local_auth_ref: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword url: The URL to sync for the flux configuration S3 bucket.
        :paramtype url: str
        :keyword bucket_name: The bucket name to sync from the url endpoint for the flux configuration.
        :paramtype bucket_name: str
        :keyword insecure: Specify whether to use insecure communication when puling data from the S3
         bucket.
        :paramtype insecure: bool
        :keyword timeout_in_seconds: The maximum time to attempt to reconcile the cluster bucket source
         with the remote.
        :paramtype timeout_in_seconds: int
        :keyword sync_interval_in_seconds: The interval at which to re-reconcile the cluster bucket
         source with the remote.
        :paramtype sync_interval_in_seconds: int
        :keyword access_key: Plaintext access key used to securely access the S3 bucket.
        :paramtype access_key: str
        :keyword local_auth_ref: Name of a local secret on the Kubernetes cluster to use as the
         authentication secret rather than the managed or user-provided configuration secrets.
        :paramtype local_auth_ref: str
        """
        super().__init__(**kwargs)
        self.url = url
        self.bucket_name = bucket_name
        self.insecure = insecure
        self.timeout_in_seconds = timeout_in_seconds
        self.sync_interval_in_seconds = sync_interval_in_seconds
        self.access_key = access_key
        self.local_auth_ref = local_auth_ref


class BucketPatchDefinition(_serialization.Model):
    """Parameters to reconcile to the Bucket source kind type.

    :ivar url: The URL to sync for the flux configuration S3 bucket.
    :vartype url: str
    :ivar bucket_name: The bucket name to sync from the url endpoint for the flux configuration.
    :vartype bucket_name: str
    :ivar insecure: Specify whether to use insecure communication when puling data from the S3
     bucket.
    :vartype insecure: bool
    :ivar timeout_in_seconds: The maximum time to attempt to reconcile the cluster bucket source
     with the remote.
    :vartype timeout_in_seconds: int
    :ivar sync_interval_in_seconds: The interval at which to re-reconcile the cluster bucket source
     with the remote.
    :vartype sync_interval_in_seconds: int
    :ivar access_key: Plaintext access key used to securely access the S3 bucket.
    :vartype access_key: str
    :ivar local_auth_ref: Name of a local secret on the Kubernetes cluster to use as the
     authentication secret rather than the managed or user-provided configuration secrets.
    :vartype local_auth_ref: str
    """

    _attribute_map = {
        "url": {"key": "url", "type": "str"},
        "bucket_name": {"key": "bucketName", "type": "str"},
        "insecure": {"key": "insecure", "type": "bool"},
        "timeout_in_seconds": {"key": "timeoutInSeconds", "type": "int"},
        "sync_interval_in_seconds": {"key": "syncIntervalInSeconds", "type": "int"},
        "access_key": {"key": "accessKey", "type": "str"},
        "local_auth_ref": {"key": "localAuthRef", "type": "str"},
    }

    def __init__(
        self,
        *,
        url: Optional[str] = None,
        bucket_name: Optional[str] = None,
        insecure: Optional[bool] = None,
        timeout_in_seconds: Optional[int] = None,
        sync_interval_in_seconds: Optional[int] = None,
        access_key: Optional[str] = None,
        local_auth_ref: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword url: The URL to sync for the flux configuration S3 bucket.
        :paramtype url: str
        :keyword bucket_name: The bucket name to sync from the url endpoint for the flux configuration.
        :paramtype bucket_name: str
        :keyword insecure: Specify whether to use insecure communication when puling data from the S3
         bucket.
        :paramtype insecure: bool
        :keyword timeout_in_seconds: The maximum time to attempt to reconcile the cluster bucket source
         with the remote.
        :paramtype timeout_in_seconds: int
        :keyword sync_interval_in_seconds: The interval at which to re-reconcile the cluster bucket
         source with the remote.
        :paramtype sync_interval_in_seconds: int
        :keyword access_key: Plaintext access key used to securely access the S3 bucket.
        :paramtype access_key: str
        :keyword local_auth_ref: Name of a local secret on the Kubernetes cluster to use as the
         authentication secret rather than the managed or user-provided configuration secrets.
        :paramtype local_auth_ref: str
        """
        super().__init__(**kwargs)
        self.url = url
        self.bucket_name = bucket_name
        self.insecure = insecure
        self.timeout_in_seconds = timeout_in_seconds
        self.sync_interval_in_seconds = sync_interval_in_seconds
        self.access_key = access_key
        self.local_auth_ref = local_auth_ref


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.info: Optional[JSON] = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details:
     list[~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None
        self.details: Optional[List["_models.ErrorDetail"]] = None
        self.additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """


class FluxConfiguration(ProxyResource):
    """The Flux Configuration object returned in Get & Put response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Top level metadata
     https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources.
    :vartype system_data: ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.SystemData
    :ivar scope: Scope at which the operator will be installed. Known values are: "cluster" and
     "namespace".
    :vartype scope: str or ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.ScopeType
    :ivar namespace: The namespace to which this configuration is installed to. Maximum of 253
     lower case alphanumeric characters, hyphen and period only.
    :vartype namespace: str
    :ivar source_kind: Source Kind to pull the configuration data from. Known values are:
     "GitRepository", "Bucket", "AzureBlob", and "OCIRepository".
    :vartype source_kind: str or
     ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.SourceKindType
    :ivar suspend: Whether this configuration should suspend its reconciliation of its
     kustomizations and sources.
    :vartype suspend: bool
    :ivar git_repository: Parameters to reconcile to the GitRepository source kind type.
    :vartype git_repository:
     ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.GitRepositoryDefinition
    :ivar bucket: Parameters to reconcile to the Bucket source kind type.
    :vartype bucket: ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.BucketDefinition
    :ivar azure_blob: Parameters to reconcile to the AzureBlob source kind type.
    :vartype azure_blob:
     ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.AzureBlobDefinition
    :ivar oci_repository: Parameters to reconcile to the OCIRepository source kind type.
    :vartype oci_repository:
     ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.OCIRepositoryDefinition
    :ivar kustomizations: Array of kustomizations used to reconcile the artifact pulled by the
     source type on the cluster.
    :vartype kustomizations: dict[str,
     ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.KustomizationDefinition]
    :ivar configuration_protected_settings: Key-value pairs of protected configuration settings for
     the configuration.
    :vartype configuration_protected_settings: dict[str, str]
    :ivar statuses: Statuses of the Flux Kubernetes resources created by the fluxConfiguration or
     created by the managed objects provisioned by the fluxConfiguration.
    :vartype statuses:
     list[~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.ObjectStatusDefinition]
    :ivar repository_public_key: Public Key associated with this fluxConfiguration (either
     generated within the cluster or provided by the user).
    :vartype repository_public_key: str
    :ivar source_synced_commit_id: Branch and/or SHA of the source commit synced with the cluster.
    :vartype source_synced_commit_id: str
    :ivar source_updated_at: Datetime the fluxConfiguration synced its source on the cluster.
    :vartype source_updated_at: ~datetime.datetime
    :ivar status_updated_at: Datetime the fluxConfiguration synced its status on the cluster with
     Azure.
    :vartype status_updated_at: ~datetime.datetime
    :ivar wait_for_reconciliation: Whether flux configuration deployment should wait for cluster to
     reconcile the kustomizations.
    :vartype wait_for_reconciliation: bool
    :ivar reconciliation_wait_duration: Maximum duration to wait for flux configuration
     reconciliation. E.g PT1H, PT5M, P1D.
    :vartype reconciliation_wait_duration: str
    :ivar compliance_state: Combined status of the Flux Kubernetes resources created by the
     fluxConfiguration or created by the managed objects. Known values are: "Compliant",
     "Non-Compliant", "Pending", "Suspended", and "Unknown".
    :vartype compliance_state: str or
     ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.FluxComplianceState
    :ivar provisioning_state: Status of the creation of the fluxConfiguration. Known values are:
     "Succeeded", "Failed", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.ProvisioningState
    :ivar error_message: Error message returned to the user in the case of provisioning failure.
    :vartype error_message: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "statuses": {"readonly": True},
        "repository_public_key": {"readonly": True},
        "source_synced_commit_id": {"readonly": True},
        "source_updated_at": {"readonly": True},
        "status_updated_at": {"readonly": True},
        "compliance_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "error_message": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "scope": {"key": "properties.scope", "type": "str"},
        "namespace": {"key": "properties.namespace", "type": "str"},
        "source_kind": {"key": "properties.sourceKind", "type": "str"},
        "suspend": {"key": "properties.suspend", "type": "bool"},
        "git_repository": {"key": "properties.gitRepository", "type": "GitRepositoryDefinition"},
        "bucket": {"key": "properties.bucket", "type": "BucketDefinition"},
        "azure_blob": {"key": "properties.azureBlob", "type": "AzureBlobDefinition"},
        "oci_repository": {"key": "properties.ociRepository", "type": "OCIRepositoryDefinition"},
        "kustomizations": {"key": "properties.kustomizations", "type": "{KustomizationDefinition}"},
        "configuration_protected_settings": {"key": "properties.configurationProtectedSettings", "type": "{str}"},
        "statuses": {"key": "properties.statuses", "type": "[ObjectStatusDefinition]"},
        "repository_public_key": {"key": "properties.repositoryPublicKey", "type": "str"},
        "source_synced_commit_id": {"key": "properties.sourceSyncedCommitId", "type": "str"},
        "source_updated_at": {"key": "properties.sourceUpdatedAt", "type": "iso-8601"},
        "status_updated_at": {"key": "properties.statusUpdatedAt", "type": "iso-8601"},
        "wait_for_reconciliation": {"key": "properties.waitForReconciliation", "type": "bool"},
        "reconciliation_wait_duration": {"key": "properties.reconciliationWaitDuration", "type": "str"},
        "compliance_state": {"key": "properties.complianceState", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "error_message": {"key": "properties.errorMessage", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        scope: Union[str, "_models.ScopeType"] = "cluster",
        namespace: str = "default",
        source_kind: Optional[Union[str, "_models.SourceKindType"]] = None,
        suspend: bool = False,
        git_repository: Optional["_models.GitRepositoryDefinition"] = None,
        bucket: Optional["_models.BucketDefinition"] = None,
        azure_blob: Optional["_models.AzureBlobDefinition"] = None,
        oci_repository: Optional["_models.OCIRepositoryDefinition"] = None,
        kustomizations: Optional[Dict[str, "_models.KustomizationDefinition"]] = None,
        configuration_protected_settings: Optional[Dict[str, str]] = None,
        wait_for_reconciliation: Optional[bool] = None,
        reconciliation_wait_duration: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword scope: Scope at which the operator will be installed. Known values are: "cluster" and
         "namespace".
        :paramtype scope: str or
         ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.ScopeType
        :keyword namespace: The namespace to which this configuration is installed to. Maximum of 253
         lower case alphanumeric characters, hyphen and period only.
        :paramtype namespace: str
        :keyword source_kind: Source Kind to pull the configuration data from. Known values are:
         "GitRepository", "Bucket", "AzureBlob", and "OCIRepository".
        :paramtype source_kind: str or
         ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.SourceKindType
        :keyword suspend: Whether this configuration should suspend its reconciliation of its
         kustomizations and sources.
        :paramtype suspend: bool
        :keyword git_repository: Parameters to reconcile to the GitRepository source kind type.
        :paramtype git_repository:
         ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.GitRepositoryDefinition
        :keyword bucket: Parameters to reconcile to the Bucket source kind type.
        :paramtype bucket:
         ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.BucketDefinition
        :keyword azure_blob: Parameters to reconcile to the AzureBlob source kind type.
        :paramtype azure_blob:
         ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.AzureBlobDefinition
        :keyword oci_repository: Parameters to reconcile to the OCIRepository source kind type.
        :paramtype oci_repository:
         ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.OCIRepositoryDefinition
        :keyword kustomizations: Array of kustomizations used to reconcile the artifact pulled by the
         source type on the cluster.
        :paramtype kustomizations: dict[str,
         ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.KustomizationDefinition]
        :keyword configuration_protected_settings: Key-value pairs of protected configuration settings
         for the configuration.
        :paramtype configuration_protected_settings: dict[str, str]
        :keyword wait_for_reconciliation: Whether flux configuration deployment should wait for cluster
         to reconcile the kustomizations.
        :paramtype wait_for_reconciliation: bool
        :keyword reconciliation_wait_duration: Maximum duration to wait for flux configuration
         reconciliation. E.g PT1H, PT5M, P1D.
        :paramtype reconciliation_wait_duration: str
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.scope = scope
        self.namespace = namespace
        self.source_kind = source_kind
        self.suspend = suspend
        self.git_repository = git_repository
        self.bucket = bucket
        self.azure_blob = azure_blob
        self.oci_repository = oci_repository
        self.kustomizations = kustomizations
        self.configuration_protected_settings = configuration_protected_settings
        self.statuses: Optional[List["_models.ObjectStatusDefinition"]] = None
        self.repository_public_key: Optional[str] = None
        self.source_synced_commit_id: Optional[str] = None
        self.source_updated_at: Optional[datetime.datetime] = None
        self.status_updated_at: Optional[datetime.datetime] = None
        self.wait_for_reconciliation = wait_for_reconciliation
        self.reconciliation_wait_duration = reconciliation_wait_duration
        self.compliance_state: Optional[Union[str, "_models.FluxComplianceState"]] = None
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.error_message: Optional[str] = None


class FluxConfigurationPatch(_serialization.Model):
    """The Flux Configuration Patch Request object.

    :ivar source_kind: Source Kind to pull the configuration data from. Known values are:
     "GitRepository", "Bucket", "AzureBlob", and "OCIRepository".
    :vartype source_kind: str or
     ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.SourceKindType
    :ivar suspend: Whether this configuration should suspend its reconciliation of its
     kustomizations and sources.
    :vartype suspend: bool
    :ivar git_repository: Parameters to reconcile to the GitRepository source kind type.
    :vartype git_repository:
     ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.GitRepositoryPatchDefinition
    :ivar bucket: Parameters to reconcile to the Bucket source kind type.
    :vartype bucket:
     ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.BucketPatchDefinition
    :ivar azure_blob: Parameters to reconcile to the AzureBlob source kind type.
    :vartype azure_blob:
     ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.AzureBlobPatchDefinition
    :ivar oci_repository: Parameters to reconcile to the OCIRepository source kind type.
    :vartype oci_repository:
     ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.OCIRepositoryPatchDefinition
    :ivar kustomizations: Array of kustomizations used to reconcile the artifact pulled by the
     source type on the cluster.
    :vartype kustomizations: dict[str,
     ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.KustomizationPatchDefinition]
    :ivar configuration_protected_settings: Key-value pairs of protected configuration settings for
     the configuration.
    :vartype configuration_protected_settings: dict[str, str]
    """

    _attribute_map = {
        "source_kind": {"key": "properties.sourceKind", "type": "str"},
        "suspend": {"key": "properties.suspend", "type": "bool"},
        "git_repository": {"key": "properties.gitRepository", "type": "GitRepositoryPatchDefinition"},
        "bucket": {"key": "properties.bucket", "type": "BucketPatchDefinition"},
        "azure_blob": {"key": "properties.azureBlob", "type": "AzureBlobPatchDefinition"},
        "oci_repository": {"key": "properties.ociRepository", "type": "OCIRepositoryPatchDefinition"},
        "kustomizations": {"key": "properties.kustomizations", "type": "{KustomizationPatchDefinition}"},
        "configuration_protected_settings": {"key": "properties.configurationProtectedSettings", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        source_kind: Optional[Union[str, "_models.SourceKindType"]] = None,
        suspend: Optional[bool] = None,
        git_repository: Optional["_models.GitRepositoryPatchDefinition"] = None,
        bucket: Optional["_models.BucketPatchDefinition"] = None,
        azure_blob: Optional["_models.AzureBlobPatchDefinition"] = None,
        oci_repository: Optional["_models.OCIRepositoryPatchDefinition"] = None,
        kustomizations: Optional[Dict[str, "_models.KustomizationPatchDefinition"]] = None,
        configuration_protected_settings: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source_kind: Source Kind to pull the configuration data from. Known values are:
         "GitRepository", "Bucket", "AzureBlob", and "OCIRepository".
        :paramtype source_kind: str or
         ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.SourceKindType
        :keyword suspend: Whether this configuration should suspend its reconciliation of its
         kustomizations and sources.
        :paramtype suspend: bool
        :keyword git_repository: Parameters to reconcile to the GitRepository source kind type.
        :paramtype git_repository:
         ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.GitRepositoryPatchDefinition
        :keyword bucket: Parameters to reconcile to the Bucket source kind type.
        :paramtype bucket:
         ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.BucketPatchDefinition
        :keyword azure_blob: Parameters to reconcile to the AzureBlob source kind type.
        :paramtype azure_blob:
         ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.AzureBlobPatchDefinition
        :keyword oci_repository: Parameters to reconcile to the OCIRepository source kind type.
        :paramtype oci_repository:
         ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.OCIRepositoryPatchDefinition
        :keyword kustomizations: Array of kustomizations used to reconcile the artifact pulled by the
         source type on the cluster.
        :paramtype kustomizations: dict[str,
         ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.KustomizationPatchDefinition]
        :keyword configuration_protected_settings: Key-value pairs of protected configuration settings
         for the configuration.
        :paramtype configuration_protected_settings: dict[str, str]
        """
        super().__init__(**kwargs)
        self.source_kind = source_kind
        self.suspend = suspend
        self.git_repository = git_repository
        self.bucket = bucket
        self.azure_blob = azure_blob
        self.oci_repository = oci_repository
        self.kustomizations = kustomizations
        self.configuration_protected_settings = configuration_protected_settings


class FluxConfigurationsList(_serialization.Model):
    """Result of the request to list Flux Configurations.  It contains a list of FluxConfiguration
    objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Flux Configurations within a Kubernetes cluster.
    :vartype value:
     list[~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.FluxConfiguration]
    :ivar next_link: URL to get the next set of configuration objects, if any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[FluxConfiguration]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.FluxConfiguration"]] = None
        self.next_link: Optional[str] = None


class GitRepositoryDefinition(_serialization.Model):
    """Parameters to reconcile to the GitRepository source kind type.

    :ivar url: The URL to sync for the flux configuration git repository.
    :vartype url: str
    :ivar timeout_in_seconds: The maximum time to attempt to reconcile the cluster git repository
     source with the remote.
    :vartype timeout_in_seconds: int
    :ivar sync_interval_in_seconds: The interval at which to re-reconcile the cluster git
     repository source with the remote.
    :vartype sync_interval_in_seconds: int
    :ivar repository_ref: The source reference for the GitRepository object.
    :vartype repository_ref:
     ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.RepositoryRefDefinition
    :ivar ssh_known_hosts: Base64-encoded known_hosts value containing public SSH keys required to
     access private git repositories over SSH.
    :vartype ssh_known_hosts: str
    :ivar https_user: Plaintext HTTPS username used to access private git repositories over HTTPS.
    :vartype https_user: str
    :ivar https_ca_cert: Base64-encoded HTTPS certificate authority contents used to access git
     private git repositories over HTTPS.
    :vartype https_ca_cert: str
    :ivar local_auth_ref: Name of a local secret on the Kubernetes cluster to use as the
     authentication secret rather than the managed or user-provided configuration secrets.
    :vartype local_auth_ref: str
    :ivar provider: Name of the provider used for authentication. Known values are: "Azure",
     "GitHub", and "Generic".
    :vartype provider: str or
     ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.ProviderType
    """

    _attribute_map = {
        "url": {"key": "url", "type": "str"},
        "timeout_in_seconds": {"key": "timeoutInSeconds", "type": "int"},
        "sync_interval_in_seconds": {"key": "syncIntervalInSeconds", "type": "int"},
        "repository_ref": {"key": "repositoryRef", "type": "RepositoryRefDefinition"},
        "ssh_known_hosts": {"key": "sshKnownHosts", "type": "str"},
        "https_user": {"key": "httpsUser", "type": "str"},
        "https_ca_cert": {"key": "httpsCACert", "type": "str"},
        "local_auth_ref": {"key": "localAuthRef", "type": "str"},
        "provider": {"key": "provider", "type": "str"},
    }

    def __init__(
        self,
        *,
        url: Optional[str] = None,
        timeout_in_seconds: int = 600,
        sync_interval_in_seconds: int = 600,
        repository_ref: Optional["_models.RepositoryRefDefinition"] = None,
        ssh_known_hosts: Optional[str] = None,
        https_user: Optional[str] = None,
        https_ca_cert: Optional[str] = None,
        local_auth_ref: Optional[str] = None,
        provider: Optional[Union[str, "_models.ProviderType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword url: The URL to sync for the flux configuration git repository.
        :paramtype url: str
        :keyword timeout_in_seconds: The maximum time to attempt to reconcile the cluster git
         repository source with the remote.
        :paramtype timeout_in_seconds: int
        :keyword sync_interval_in_seconds: The interval at which to re-reconcile the cluster git
         repository source with the remote.
        :paramtype sync_interval_in_seconds: int
        :keyword repository_ref: The source reference for the GitRepository object.
        :paramtype repository_ref:
         ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.RepositoryRefDefinition
        :keyword ssh_known_hosts: Base64-encoded known_hosts value containing public SSH keys required
         to access private git repositories over SSH.
        :paramtype ssh_known_hosts: str
        :keyword https_user: Plaintext HTTPS username used to access private git repositories over
         HTTPS.
        :paramtype https_user: str
        :keyword https_ca_cert: Base64-encoded HTTPS certificate authority contents used to access git
         private git repositories over HTTPS.
        :paramtype https_ca_cert: str
        :keyword local_auth_ref: Name of a local secret on the Kubernetes cluster to use as the
         authentication secret rather than the managed or user-provided configuration secrets.
        :paramtype local_auth_ref: str
        :keyword provider: Name of the provider used for authentication. Known values are: "Azure",
         "GitHub", and "Generic".
        :paramtype provider: str or
         ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.ProviderType
        """
        super().__init__(**kwargs)
        self.url = url
        self.timeout_in_seconds = timeout_in_seconds
        self.sync_interval_in_seconds = sync_interval_in_seconds
        self.repository_ref = repository_ref
        self.ssh_known_hosts = ssh_known_hosts
        self.https_user = https_user
        self.https_ca_cert = https_ca_cert
        self.local_auth_ref = local_auth_ref
        self.provider = provider


class GitRepositoryPatchDefinition(_serialization.Model):
    """Parameters to reconcile to the GitRepository source kind type.

    :ivar url: The URL to sync for the flux configuration git repository.
    :vartype url: str
    :ivar timeout_in_seconds: The maximum time to attempt to reconcile the cluster git repository
     source with the remote.
    :vartype timeout_in_seconds: int
    :ivar sync_interval_in_seconds: The interval at which to re-reconcile the cluster git
     repository source with the remote.
    :vartype sync_interval_in_seconds: int
    :ivar repository_ref: The source reference for the GitRepository object.
    :vartype repository_ref:
     ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.RepositoryRefDefinition
    :ivar ssh_known_hosts: Base64-encoded known_hosts value containing public SSH keys required to
     access private git repositories over SSH.
    :vartype ssh_known_hosts: str
    :ivar https_user: Plaintext HTTPS username used to access private git repositories over HTTPS.
    :vartype https_user: str
    :ivar https_ca_cert: Base64-encoded HTTPS certificate authority contents used to access git
     private git repositories over HTTPS.
    :vartype https_ca_cert: str
    :ivar local_auth_ref: Name of a local secret on the Kubernetes cluster to use as the
     authentication secret rather than the managed or user-provided configuration secrets.
    :vartype local_auth_ref: str
    :ivar provider: Name of the provider used for authentication. Known values are: "Azure",
     "GitHub", and "Generic".
    :vartype provider: str or
     ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.ProviderType
    """

    _attribute_map = {
        "url": {"key": "url", "type": "str"},
        "timeout_in_seconds": {"key": "timeoutInSeconds", "type": "int"},
        "sync_interval_in_seconds": {"key": "syncIntervalInSeconds", "type": "int"},
        "repository_ref": {"key": "repositoryRef", "type": "RepositoryRefDefinition"},
        "ssh_known_hosts": {"key": "sshKnownHosts", "type": "str"},
        "https_user": {"key": "httpsUser", "type": "str"},
        "https_ca_cert": {"key": "httpsCACert", "type": "str"},
        "local_auth_ref": {"key": "localAuthRef", "type": "str"},
        "provider": {"key": "provider", "type": "str"},
    }

    def __init__(
        self,
        *,
        url: Optional[str] = None,
        timeout_in_seconds: Optional[int] = None,
        sync_interval_in_seconds: Optional[int] = None,
        repository_ref: Optional["_models.RepositoryRefDefinition"] = None,
        ssh_known_hosts: Optional[str] = None,
        https_user: Optional[str] = None,
        https_ca_cert: Optional[str] = None,
        local_auth_ref: Optional[str] = None,
        provider: Optional[Union[str, "_models.ProviderType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword url: The URL to sync for the flux configuration git repository.
        :paramtype url: str
        :keyword timeout_in_seconds: The maximum time to attempt to reconcile the cluster git
         repository source with the remote.
        :paramtype timeout_in_seconds: int
        :keyword sync_interval_in_seconds: The interval at which to re-reconcile the cluster git
         repository source with the remote.
        :paramtype sync_interval_in_seconds: int
        :keyword repository_ref: The source reference for the GitRepository object.
        :paramtype repository_ref:
         ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.RepositoryRefDefinition
        :keyword ssh_known_hosts: Base64-encoded known_hosts value containing public SSH keys required
         to access private git repositories over SSH.
        :paramtype ssh_known_hosts: str
        :keyword https_user: Plaintext HTTPS username used to access private git repositories over
         HTTPS.
        :paramtype https_user: str
        :keyword https_ca_cert: Base64-encoded HTTPS certificate authority contents used to access git
         private git repositories over HTTPS.
        :paramtype https_ca_cert: str
        :keyword local_auth_ref: Name of a local secret on the Kubernetes cluster to use as the
         authentication secret rather than the managed or user-provided configuration secrets.
        :paramtype local_auth_ref: str
        :keyword provider: Name of the provider used for authentication. Known values are: "Azure",
         "GitHub", and "Generic".
        :paramtype provider: str or
         ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.ProviderType
        """
        super().__init__(**kwargs)
        self.url = url
        self.timeout_in_seconds = timeout_in_seconds
        self.sync_interval_in_seconds = sync_interval_in_seconds
        self.repository_ref = repository_ref
        self.ssh_known_hosts = ssh_known_hosts
        self.https_user = https_user
        self.https_ca_cert = https_ca_cert
        self.local_auth_ref = local_auth_ref
        self.provider = provider


class HelmReleasePropertiesDefinition(_serialization.Model):
    """Properties for HelmRelease objects.

    :ivar last_revision_applied: The revision number of the last released object change.
    :vartype last_revision_applied: int
    :ivar helm_chart_ref: The reference to the HelmChart object used as the source to this
     HelmRelease.
    :vartype helm_chart_ref:
     ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.ObjectReferenceDefinition
    :ivar failure_count: Total number of times that the HelmRelease failed to install or upgrade.
    :vartype failure_count: int
    :ivar install_failure_count: Number of times that the HelmRelease failed to install.
    :vartype install_failure_count: int
    :ivar upgrade_failure_count: Number of times that the HelmRelease failed to upgrade.
    :vartype upgrade_failure_count: int
    """

    _attribute_map = {
        "last_revision_applied": {"key": "lastRevisionApplied", "type": "int"},
        "helm_chart_ref": {"key": "helmChartRef", "type": "ObjectReferenceDefinition"},
        "failure_count": {"key": "failureCount", "type": "int"},
        "install_failure_count": {"key": "installFailureCount", "type": "int"},
        "upgrade_failure_count": {"key": "upgradeFailureCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        last_revision_applied: Optional[int] = None,
        helm_chart_ref: Optional["_models.ObjectReferenceDefinition"] = None,
        failure_count: Optional[int] = None,
        install_failure_count: Optional[int] = None,
        upgrade_failure_count: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword last_revision_applied: The revision number of the last released object change.
        :paramtype last_revision_applied: int
        :keyword helm_chart_ref: The reference to the HelmChart object used as the source to this
         HelmRelease.
        :paramtype helm_chart_ref:
         ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.ObjectReferenceDefinition
        :keyword failure_count: Total number of times that the HelmRelease failed to install or
         upgrade.
        :paramtype failure_count: int
        :keyword install_failure_count: Number of times that the HelmRelease failed to install.
        :paramtype install_failure_count: int
        :keyword upgrade_failure_count: Number of times that the HelmRelease failed to upgrade.
        :paramtype upgrade_failure_count: int
        """
        super().__init__(**kwargs)
        self.last_revision_applied = last_revision_applied
        self.helm_chart_ref = helm_chart_ref
        self.failure_count = failure_count
        self.install_failure_count = install_failure_count
        self.upgrade_failure_count = upgrade_failure_count


class KustomizationDefinition(_serialization.Model):
    """The Kustomization defining how to reconcile the artifact pulled by the source type on the
    cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the Kustomization, matching the key in the Kustomizations object map.
    :vartype name: str
    :ivar path: The path in the source reference to reconcile on the cluster.
    :vartype path: str
    :ivar depends_on: Specifies other Kustomizations that this Kustomization depends on. This
     Kustomization will not reconcile until all dependencies have completed their reconciliation.
    :vartype depends_on: list[str]
    :ivar timeout_in_seconds: The maximum time to attempt to reconcile the Kustomization on the
     cluster.
    :vartype timeout_in_seconds: int
    :ivar sync_interval_in_seconds: The interval at which to re-reconcile the Kustomization on the
     cluster.
    :vartype sync_interval_in_seconds: int
    :ivar retry_interval_in_seconds: The interval at which to re-reconcile the Kustomization on the
     cluster in the event of failure on reconciliation.
    :vartype retry_interval_in_seconds: int
    :ivar prune: Enable/disable garbage collections of Kubernetes objects created by this
     Kustomization.
    :vartype prune: bool
    :ivar force: Enable/disable re-creating Kubernetes resources on the cluster when patching fails
     due to an immutable field change.
    :vartype force: bool
    :ivar wait: Enable/disable health check for all Kubernetes objects created by this
     Kustomization.
    :vartype wait: bool
    :ivar post_build: Used for variable substitution for this Kustomization after kustomize build.
    :vartype post_build:
     ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.PostBuildDefinition
    """

    _validation = {
        "name": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "path": {"key": "path", "type": "str"},
        "depends_on": {"key": "dependsOn", "type": "[str]"},
        "timeout_in_seconds": {"key": "timeoutInSeconds", "type": "int"},
        "sync_interval_in_seconds": {"key": "syncIntervalInSeconds", "type": "int"},
        "retry_interval_in_seconds": {"key": "retryIntervalInSeconds", "type": "int"},
        "prune": {"key": "prune", "type": "bool"},
        "force": {"key": "force", "type": "bool"},
        "wait": {"key": "wait", "type": "bool"},
        "post_build": {"key": "postBuild", "type": "PostBuildDefinition"},
    }

    def __init__(
        self,
        *,
        path: str = "",
        depends_on: Optional[List[str]] = None,
        timeout_in_seconds: int = 600,
        sync_interval_in_seconds: int = 600,
        retry_interval_in_seconds: Optional[int] = None,
        prune: bool = False,
        force: bool = False,
        wait: bool = True,
        post_build: Optional["_models.PostBuildDefinition"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword path: The path in the source reference to reconcile on the cluster.
        :paramtype path: str
        :keyword depends_on: Specifies other Kustomizations that this Kustomization depends on. This
         Kustomization will not reconcile until all dependencies have completed their reconciliation.
        :paramtype depends_on: list[str]
        :keyword timeout_in_seconds: The maximum time to attempt to reconcile the Kustomization on the
         cluster.
        :paramtype timeout_in_seconds: int
        :keyword sync_interval_in_seconds: The interval at which to re-reconcile the Kustomization on
         the cluster.
        :paramtype sync_interval_in_seconds: int
        :keyword retry_interval_in_seconds: The interval at which to re-reconcile the Kustomization on
         the cluster in the event of failure on reconciliation.
        :paramtype retry_interval_in_seconds: int
        :keyword prune: Enable/disable garbage collections of Kubernetes objects created by this
         Kustomization.
        :paramtype prune: bool
        :keyword force: Enable/disable re-creating Kubernetes resources on the cluster when patching
         fails due to an immutable field change.
        :paramtype force: bool
        :keyword wait: Enable/disable health check for all Kubernetes objects created by this
         Kustomization.
        :paramtype wait: bool
        :keyword post_build: Used for variable substitution for this Kustomization after kustomize
         build.
        :paramtype post_build:
         ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.PostBuildDefinition
        """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.path = path
        self.depends_on = depends_on
        self.timeout_in_seconds = timeout_in_seconds
        self.sync_interval_in_seconds = sync_interval_in_seconds
        self.retry_interval_in_seconds = retry_interval_in_seconds
        self.prune = prune
        self.force = force
        self.wait = wait
        self.post_build = post_build


class KustomizationPatchDefinition(_serialization.Model):
    """The Kustomization defining how to reconcile the artifact pulled by the source type on the
    cluster.

    :ivar path: The path in the source reference to reconcile on the cluster.
    :vartype path: str
    :ivar depends_on: Specifies other Kustomizations that this Kustomization depends on. This
     Kustomization will not reconcile until all dependencies have completed their reconciliation.
    :vartype depends_on: list[str]
    :ivar timeout_in_seconds: The maximum time to attempt to reconcile the Kustomization on the
     cluster.
    :vartype timeout_in_seconds: int
    :ivar sync_interval_in_seconds: The interval at which to re-reconcile the Kustomization on the
     cluster.
    :vartype sync_interval_in_seconds: int
    :ivar retry_interval_in_seconds: The interval at which to re-reconcile the Kustomization on the
     cluster in the event of failure on reconciliation.
    :vartype retry_interval_in_seconds: int
    :ivar prune: Enable/disable garbage collections of Kubernetes objects created by this
     Kustomization.
    :vartype prune: bool
    :ivar force: Enable/disable re-creating Kubernetes resources on the cluster when patching fails
     due to an immutable field change.
    :vartype force: bool
    :ivar wait: Enable/disable health check for all Kubernetes objects created by this
     Kustomization.
    :vartype wait: bool
    :ivar post_build: Used for variable substitution for this Kustomization after kustomize build.
    :vartype post_build:
     ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.PostBuildPatchDefinition
    """

    _attribute_map = {
        "path": {"key": "path", "type": "str"},
        "depends_on": {"key": "dependsOn", "type": "[str]"},
        "timeout_in_seconds": {"key": "timeoutInSeconds", "type": "int"},
        "sync_interval_in_seconds": {"key": "syncIntervalInSeconds", "type": "int"},
        "retry_interval_in_seconds": {"key": "retryIntervalInSeconds", "type": "int"},
        "prune": {"key": "prune", "type": "bool"},
        "force": {"key": "force", "type": "bool"},
        "wait": {"key": "wait", "type": "bool"},
        "post_build": {"key": "postBuild", "type": "PostBuildPatchDefinition"},
    }

    def __init__(
        self,
        *,
        path: Optional[str] = None,
        depends_on: Optional[List[str]] = None,
        timeout_in_seconds: Optional[int] = None,
        sync_interval_in_seconds: Optional[int] = None,
        retry_interval_in_seconds: Optional[int] = None,
        prune: Optional[bool] = None,
        force: Optional[bool] = None,
        wait: Optional[bool] = None,
        post_build: Optional["_models.PostBuildPatchDefinition"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword path: The path in the source reference to reconcile on the cluster.
        :paramtype path: str
        :keyword depends_on: Specifies other Kustomizations that this Kustomization depends on. This
         Kustomization will not reconcile until all dependencies have completed their reconciliation.
        :paramtype depends_on: list[str]
        :keyword timeout_in_seconds: The maximum time to attempt to reconcile the Kustomization on the
         cluster.
        :paramtype timeout_in_seconds: int
        :keyword sync_interval_in_seconds: The interval at which to re-reconcile the Kustomization on
         the cluster.
        :paramtype sync_interval_in_seconds: int
        :keyword retry_interval_in_seconds: The interval at which to re-reconcile the Kustomization on
         the cluster in the event of failure on reconciliation.
        :paramtype retry_interval_in_seconds: int
        :keyword prune: Enable/disable garbage collections of Kubernetes objects created by this
         Kustomization.
        :paramtype prune: bool
        :keyword force: Enable/disable re-creating Kubernetes resources on the cluster when patching
         fails due to an immutable field change.
        :paramtype force: bool
        :keyword wait: Enable/disable health check for all Kubernetes objects created by this
         Kustomization.
        :paramtype wait: bool
        :keyword post_build: Used for variable substitution for this Kustomization after kustomize
         build.
        :paramtype post_build:
         ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.PostBuildPatchDefinition
        """
        super().__init__(**kwargs)
        self.path = path
        self.depends_on = depends_on
        self.timeout_in_seconds = timeout_in_seconds
        self.sync_interval_in_seconds = sync_interval_in_seconds
        self.retry_interval_in_seconds = retry_interval_in_seconds
        self.prune = prune
        self.force = force
        self.wait = wait
        self.post_build = post_build


class LayerSelectorDefinition(_serialization.Model):
    """Parameters to specify which layer to pull from the OCI artifact. By default, the first layer in
    the artifact is pulled.

    :ivar media_type: The first layer matching the specified media type will be used.
    :vartype media_type: str
    :ivar operation: The operation to be performed on the selected layer. The default value is
     'extract', but it can be set to 'copy'. Known values are: "extract" and "copy".
    :vartype operation: str or
     ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.OperationType
    """

    _attribute_map = {
        "media_type": {"key": "mediaType", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
    }

    def __init__(
        self,
        *,
        media_type: Optional[str] = None,
        operation: Optional[Union[str, "_models.OperationType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword media_type: The first layer matching the specified media type will be used.
        :paramtype media_type: str
        :keyword operation: The operation to be performed on the selected layer. The default value is
         'extract', but it can be set to 'copy'. Known values are: "extract" and "copy".
        :paramtype operation: str or
         ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.OperationType
        """
        super().__init__(**kwargs)
        self.media_type = media_type
        self.operation = operation


class LayerSelectorPatchDefinition(_serialization.Model):
    """Parameters to specify which layer to pull from the OCI artifact. By default, the first layer in
    the artifact is pulled.

    :ivar media_type: The first layer matching the specified media type will be used.
    :vartype media_type: str
    :ivar operation: The operation to be performed on the selected layer. The default value is
     'extract', but it can be set to 'copy'. Known values are: "extract" and "copy".
    :vartype operation: str or
     ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.OperationType
    """

    _attribute_map = {
        "media_type": {"key": "mediaType", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
    }

    def __init__(
        self,
        *,
        media_type: Optional[str] = None,
        operation: Optional[Union[str, "_models.OperationType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword media_type: The first layer matching the specified media type will be used.
        :paramtype media_type: str
        :keyword operation: The operation to be performed on the selected layer. The default value is
         'extract', but it can be set to 'copy'. Known values are: "extract" and "copy".
        :paramtype operation: str or
         ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.OperationType
        """
        super().__init__(**kwargs)
        self.media_type = media_type
        self.operation = operation


class ManagedIdentityDefinition(_serialization.Model):
    """Parameters to authenticate using a Managed Identity.

    :ivar client_id: The client Id for authenticating a Managed Identity.
    :vartype client_id: str
    """

    _attribute_map = {
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, *, client_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword client_id: The client Id for authenticating a Managed Identity.
        :paramtype client_id: str
        """
        super().__init__(**kwargs)
        self.client_id = client_id


class ManagedIdentityPatchDefinition(_serialization.Model):
    """Parameters to authenticate using a Managed Identity.

    :ivar client_id: The client Id for authenticating a Managed Identity.
    :vartype client_id: str
    """

    _attribute_map = {
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, *, client_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword client_id: The client Id for authenticating a Managed Identity.
        :paramtype client_id: str
        """
        super().__init__(**kwargs)
        self.client_id = client_id


class MatchOidcIdentityDefinition(_serialization.Model):
    """MatchOIDCIdentity defines the criteria for matching the identity while verifying an OCI
    artifact.

    :ivar issuer: The regex pattern to match against to verify the OIDC issuer.
    :vartype issuer: str
    :ivar subject: The regex pattern to match against to verify the identity subject.
    :vartype subject: str
    """

    _attribute_map = {
        "issuer": {"key": "issuer", "type": "str"},
        "subject": {"key": "subject", "type": "str"},
    }

    def __init__(self, *, issuer: Optional[str] = None, subject: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword issuer: The regex pattern to match against to verify the OIDC issuer.
        :paramtype issuer: str
        :keyword subject: The regex pattern to match against to verify the identity subject.
        :paramtype subject: str
        """
        super().__init__(**kwargs)
        self.issuer = issuer
        self.subject = subject


class MatchOidcIdentityPatchDefinition(_serialization.Model):
    """MatchOIDCIdentity defines the criteria for matching the identity while verifying an OCI
    artifact.

    :ivar issuer: The regex pattern to match against to verify the OIDC issuer.
    :vartype issuer: str
    :ivar subject: The regex pattern to match against to verify the identity subject.
    :vartype subject: str
    """

    _attribute_map = {
        "issuer": {"key": "issuer", "type": "str"},
        "subject": {"key": "subject", "type": "str"},
    }

    def __init__(self, *, issuer: Optional[str] = None, subject: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword issuer: The regex pattern to match against to verify the OIDC issuer.
        :paramtype issuer: str
        :keyword subject: The regex pattern to match against to verify the identity subject.
        :paramtype subject: str
        """
        super().__init__(**kwargs)
        self.issuer = issuer
        self.subject = subject


class ObjectReferenceDefinition(_serialization.Model):
    """Object reference to a Kubernetes object on a cluster.

    :ivar name: Name of the object.
    :vartype name: str
    :ivar namespace: Namespace of the object.
    :vartype namespace: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "namespace": {"key": "namespace", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, namespace: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Name of the object.
        :paramtype name: str
        :keyword namespace: Namespace of the object.
        :paramtype namespace: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.namespace = namespace


class ObjectStatusConditionDefinition(_serialization.Model):
    """Status condition of Kubernetes object.

    :ivar last_transition_time: Last time this status condition has changed.
    :vartype last_transition_time: ~datetime.datetime
    :ivar message: A more verbose description of the object status condition.
    :vartype message: str
    :ivar reason: Reason for the specified status condition type status.
    :vartype reason: str
    :ivar status: Status of the Kubernetes object condition type.
    :vartype status: str
    :ivar type: Object status condition type for this object.
    :vartype type: str
    """

    _attribute_map = {
        "last_transition_time": {"key": "lastTransitionTime", "type": "iso-8601"},
        "message": {"key": "message", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        last_transition_time: Optional[datetime.datetime] = None,
        message: Optional[str] = None,
        reason: Optional[str] = None,
        status: Optional[str] = None,
        type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword last_transition_time: Last time this status condition has changed.
        :paramtype last_transition_time: ~datetime.datetime
        :keyword message: A more verbose description of the object status condition.
        :paramtype message: str
        :keyword reason: Reason for the specified status condition type status.
        :paramtype reason: str
        :keyword status: Status of the Kubernetes object condition type.
        :paramtype status: str
        :keyword type: Object status condition type for this object.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.last_transition_time = last_transition_time
        self.message = message
        self.reason = reason
        self.status = status
        self.type = type


class ObjectStatusDefinition(_serialization.Model):
    """Statuses of objects deployed by the user-specified kustomizations from the git repository.

    :ivar name: Name of the applied object.
    :vartype name: str
    :ivar namespace: Namespace of the applied object.
    :vartype namespace: str
    :ivar kind: Kind of the applied object.
    :vartype kind: str
    :ivar compliance_state: Compliance state of the applied object showing whether the applied
     object has come into a ready state on the cluster. Known values are: "Compliant",
     "Non-Compliant", "Pending", "Suspended", and "Unknown".
    :vartype compliance_state: str or
     ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.FluxComplianceState
    :ivar applied_by: Object reference to the Kustomization that applied this object.
    :vartype applied_by:
     ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.ObjectReferenceDefinition
    :ivar status_conditions: List of Kubernetes object status conditions present on the cluster.
    :vartype status_conditions:
     list[~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.ObjectStatusConditionDefinition]
    :ivar helm_release_properties: Additional properties that are provided from objects of the
     HelmRelease kind.
    :vartype helm_release_properties:
     ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.HelmReleasePropertiesDefinition
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "namespace": {"key": "namespace", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "compliance_state": {"key": "complianceState", "type": "str"},
        "applied_by": {"key": "appliedBy", "type": "ObjectReferenceDefinition"},
        "status_conditions": {"key": "statusConditions", "type": "[ObjectStatusConditionDefinition]"},
        "helm_release_properties": {"key": "helmReleaseProperties", "type": "HelmReleasePropertiesDefinition"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        namespace: Optional[str] = None,
        kind: Optional[str] = None,
        compliance_state: Union[str, "_models.FluxComplianceState"] = "Unknown",
        applied_by: Optional["_models.ObjectReferenceDefinition"] = None,
        status_conditions: Optional[List["_models.ObjectStatusConditionDefinition"]] = None,
        helm_release_properties: Optional["_models.HelmReleasePropertiesDefinition"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the applied object.
        :paramtype name: str
        :keyword namespace: Namespace of the applied object.
        :paramtype namespace: str
        :keyword kind: Kind of the applied object.
        :paramtype kind: str
        :keyword compliance_state: Compliance state of the applied object showing whether the applied
         object has come into a ready state on the cluster. Known values are: "Compliant",
         "Non-Compliant", "Pending", "Suspended", and "Unknown".
        :paramtype compliance_state: str or
         ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.FluxComplianceState
        :keyword applied_by: Object reference to the Kustomization that applied this object.
        :paramtype applied_by:
         ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.ObjectReferenceDefinition
        :keyword status_conditions: List of Kubernetes object status conditions present on the cluster.
        :paramtype status_conditions:
         list[~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.ObjectStatusConditionDefinition]
        :keyword helm_release_properties: Additional properties that are provided from objects of the
         HelmRelease kind.
        :paramtype helm_release_properties:
         ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.HelmReleasePropertiesDefinition
        """
        super().__init__(**kwargs)
        self.name = name
        self.namespace = namespace
        self.kind = kind
        self.compliance_state = compliance_state
        self.applied_by = applied_by
        self.status_conditions = status_conditions
        self.helm_release_properties = helm_release_properties


class OCIRepositoryDefinition(_serialization.Model):
    """Parameters to reconcile to the OCIRepository source kind type.

    :ivar url: The URL to sync for the flux configuration OCI repository.
    :vartype url: str
    :ivar timeout_in_seconds: The maximum time to attempt to reconcile the cluster OCI repository
     source with the remote.
    :vartype timeout_in_seconds: int
    :ivar sync_interval_in_seconds: The interval at which to re-reconcile the cluster OCI
     repository source with the remote.
    :vartype sync_interval_in_seconds: int
    :ivar repository_ref: The source reference for the OCIRepository object.
    :vartype repository_ref:
     ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.OCIRepositoryRefDefinition
    :ivar layer_selector: The layer to be pulled from the OCI artifact.
    :vartype layer_selector:
     ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.LayerSelectorDefinition
    :ivar verify: Verification of the authenticity of an OCI Artifact.
    :vartype verify: ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.VerifyDefinition
    :ivar insecure: Specify whether to allow connecting to a non-TLS HTTP container registry.
    :vartype insecure: bool
    :ivar use_workload_identity: Specifies whether to use Workload Identity to authenticate with
     the OCI repository.
    :vartype use_workload_identity: bool
    :ivar service_account_name: The service account name to authenticate with the OCI repository.
    :vartype service_account_name: str
    :ivar tls_config: Parameters to authenticate using TLS config for OCI repository.
    :vartype tls_config:
     ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.TlsConfigDefinition
    :ivar local_auth_ref: Name of a local secret on the Kubernetes cluster to use as the
     authentication secret rather than the managed or user-provided configuration secrets.
    :vartype local_auth_ref: str
    """

    _attribute_map = {
        "url": {"key": "url", "type": "str"},
        "timeout_in_seconds": {"key": "timeoutInSeconds", "type": "int"},
        "sync_interval_in_seconds": {"key": "syncIntervalInSeconds", "type": "int"},
        "repository_ref": {"key": "repositoryRef", "type": "OCIRepositoryRefDefinition"},
        "layer_selector": {"key": "layerSelector", "type": "LayerSelectorDefinition"},
        "verify": {"key": "verify", "type": "VerifyDefinition"},
        "insecure": {"key": "insecure", "type": "bool"},
        "use_workload_identity": {"key": "useWorkloadIdentity", "type": "bool"},
        "service_account_name": {"key": "serviceAccountName", "type": "str"},
        "tls_config": {"key": "tlsConfig", "type": "TlsConfigDefinition"},
        "local_auth_ref": {"key": "localAuthRef", "type": "str"},
    }

    def __init__(
        self,
        *,
        url: Optional[str] = None,
        timeout_in_seconds: int = 600,
        sync_interval_in_seconds: int = 600,
        repository_ref: Optional["_models.OCIRepositoryRefDefinition"] = None,
        layer_selector: Optional["_models.LayerSelectorDefinition"] = None,
        verify: Optional["_models.VerifyDefinition"] = None,
        insecure: bool = False,
        use_workload_identity: bool = False,
        service_account_name: Optional[str] = None,
        tls_config: Optional["_models.TlsConfigDefinition"] = None,
        local_auth_ref: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword url: The URL to sync for the flux configuration OCI repository.
        :paramtype url: str
        :keyword timeout_in_seconds: The maximum time to attempt to reconcile the cluster OCI
         repository source with the remote.
        :paramtype timeout_in_seconds: int
        :keyword sync_interval_in_seconds: The interval at which to re-reconcile the cluster OCI
         repository source with the remote.
        :paramtype sync_interval_in_seconds: int
        :keyword repository_ref: The source reference for the OCIRepository object.
        :paramtype repository_ref:
         ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.OCIRepositoryRefDefinition
        :keyword layer_selector: The layer to be pulled from the OCI artifact.
        :paramtype layer_selector:
         ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.LayerSelectorDefinition
        :keyword verify: Verification of the authenticity of an OCI Artifact.
        :paramtype verify:
         ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.VerifyDefinition
        :keyword insecure: Specify whether to allow connecting to a non-TLS HTTP container registry.
        :paramtype insecure: bool
        :keyword use_workload_identity: Specifies whether to use Workload Identity to authenticate with
         the OCI repository.
        :paramtype use_workload_identity: bool
        :keyword service_account_name: The service account name to authenticate with the OCI
         repository.
        :paramtype service_account_name: str
        :keyword tls_config: Parameters to authenticate using TLS config for OCI repository.
        :paramtype tls_config:
         ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.TlsConfigDefinition
        :keyword local_auth_ref: Name of a local secret on the Kubernetes cluster to use as the
         authentication secret rather than the managed or user-provided configuration secrets.
        :paramtype local_auth_ref: str
        """
        super().__init__(**kwargs)
        self.url = url
        self.timeout_in_seconds = timeout_in_seconds
        self.sync_interval_in_seconds = sync_interval_in_seconds
        self.repository_ref = repository_ref
        self.layer_selector = layer_selector
        self.verify = verify
        self.insecure = insecure
        self.use_workload_identity = use_workload_identity
        self.service_account_name = service_account_name
        self.tls_config = tls_config
        self.local_auth_ref = local_auth_ref


class OCIRepositoryPatchDefinition(_serialization.Model):
    """Parameters to reconcile to the OCIRepository source kind type.

    :ivar url: The URL to sync for the flux configuration OCI repository.
    :vartype url: str
    :ivar timeout_in_seconds: The maximum time to attempt to reconcile the cluster OCI repository
     source with the remote.
    :vartype timeout_in_seconds: int
    :ivar sync_interval_in_seconds: The interval at which to re-reconcile the cluster OCI
     repository source with the remote.
    :vartype sync_interval_in_seconds: int
    :ivar repository_ref: The source reference for the OCIRepository object.
    :vartype repository_ref:
     ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.OCIRepositoryRefPatchDefinition
    :ivar layer_selector: The layer to be pulled from the OCI artifact.
    :vartype layer_selector:
     ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.LayerSelectorPatchDefinition
    :ivar verify: Verification of the authenticity of an OCI Artifact.
    :vartype verify:
     ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.VerifyPatchDefinition
    :ivar insecure: Specify whether to allow connecting to a non-TLS HTTP container registry.
    :vartype insecure: bool
    :ivar use_workload_identity: Specifies whether to use Workload Identity to authenticate with
     the OCI repository.
    :vartype use_workload_identity: bool
    :ivar service_account_name: The service account name to authenticate with the OCI repository.
    :vartype service_account_name: str
    :ivar tls_config: Parameters to authenticate using TLS config for OCI repository.
    :vartype tls_config:
     ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.TlsConfigPatchDefinition
    :ivar local_auth_ref: Name of a local secret on the Kubernetes cluster to use as the
     authentication secret rather than the managed or user-provided configuration secrets.
    :vartype local_auth_ref: str
    """

    _attribute_map = {
        "url": {"key": "url", "type": "str"},
        "timeout_in_seconds": {"key": "timeoutInSeconds", "type": "int"},
        "sync_interval_in_seconds": {"key": "syncIntervalInSeconds", "type": "int"},
        "repository_ref": {"key": "repositoryRef", "type": "OCIRepositoryRefPatchDefinition"},
        "layer_selector": {"key": "layerSelector", "type": "LayerSelectorPatchDefinition"},
        "verify": {"key": "verify", "type": "VerifyPatchDefinition"},
        "insecure": {"key": "insecure", "type": "bool"},
        "use_workload_identity": {"key": "useWorkloadIdentity", "type": "bool"},
        "service_account_name": {"key": "serviceAccountName", "type": "str"},
        "tls_config": {"key": "tlsConfig", "type": "TlsConfigPatchDefinition"},
        "local_auth_ref": {"key": "localAuthRef", "type": "str"},
    }

    def __init__(
        self,
        *,
        url: Optional[str] = None,
        timeout_in_seconds: Optional[int] = None,
        sync_interval_in_seconds: Optional[int] = None,
        repository_ref: Optional["_models.OCIRepositoryRefPatchDefinition"] = None,
        layer_selector: Optional["_models.LayerSelectorPatchDefinition"] = None,
        verify: Optional["_models.VerifyPatchDefinition"] = None,
        insecure: bool = False,
        use_workload_identity: bool = False,
        service_account_name: Optional[str] = None,
        tls_config: Optional["_models.TlsConfigPatchDefinition"] = None,
        local_auth_ref: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword url: The URL to sync for the flux configuration OCI repository.
        :paramtype url: str
        :keyword timeout_in_seconds: The maximum time to attempt to reconcile the cluster OCI
         repository source with the remote.
        :paramtype timeout_in_seconds: int
        :keyword sync_interval_in_seconds: The interval at which to re-reconcile the cluster OCI
         repository source with the remote.
        :paramtype sync_interval_in_seconds: int
        :keyword repository_ref: The source reference for the OCIRepository object.
        :paramtype repository_ref:
         ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.OCIRepositoryRefPatchDefinition
        :keyword layer_selector: The layer to be pulled from the OCI artifact.
        :paramtype layer_selector:
         ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.LayerSelectorPatchDefinition
        :keyword verify: Verification of the authenticity of an OCI Artifact.
        :paramtype verify:
         ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.VerifyPatchDefinition
        :keyword insecure: Specify whether to allow connecting to a non-TLS HTTP container registry.
        :paramtype insecure: bool
        :keyword use_workload_identity: Specifies whether to use Workload Identity to authenticate with
         the OCI repository.
        :paramtype use_workload_identity: bool
        :keyword service_account_name: The service account name to authenticate with the OCI
         repository.
        :paramtype service_account_name: str
        :keyword tls_config: Parameters to authenticate using TLS config for OCI repository.
        :paramtype tls_config:
         ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.TlsConfigPatchDefinition
        :keyword local_auth_ref: Name of a local secret on the Kubernetes cluster to use as the
         authentication secret rather than the managed or user-provided configuration secrets.
        :paramtype local_auth_ref: str
        """
        super().__init__(**kwargs)
        self.url = url
        self.timeout_in_seconds = timeout_in_seconds
        self.sync_interval_in_seconds = sync_interval_in_seconds
        self.repository_ref = repository_ref
        self.layer_selector = layer_selector
        self.verify = verify
        self.insecure = insecure
        self.use_workload_identity = use_workload_identity
        self.service_account_name = service_account_name
        self.tls_config = tls_config
        self.local_auth_ref = local_auth_ref


class OCIRepositoryRefDefinition(_serialization.Model):
    """The source reference for the OCIRepository object.

    :ivar tag: The OCI repository image tag name to pull. This defaults to 'latest'.
    :vartype tag: str
    :ivar semver: The semver range used to match against OCI repository tags. This takes precedence
     over tag.
    :vartype semver: str
    :ivar digest: The image digest to pull from OCI repository, the value should be in the format
     ‘sha256:’. This takes precedence over semver.
    :vartype digest: str
    """

    _attribute_map = {
        "tag": {"key": "tag", "type": "str"},
        "semver": {"key": "semver", "type": "str"},
        "digest": {"key": "digest", "type": "str"},
    }

    def __init__(
        self, *, tag: Optional[str] = None, semver: Optional[str] = None, digest: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword tag: The OCI repository image tag name to pull. This defaults to 'latest'.
        :paramtype tag: str
        :keyword semver: The semver range used to match against OCI repository tags. This takes
         precedence over tag.
        :paramtype semver: str
        :keyword digest: The image digest to pull from OCI repository, the value should be in the
         format ‘sha256:’. This takes precedence over semver.
        :paramtype digest: str
        """
        super().__init__(**kwargs)
        self.tag = tag
        self.semver = semver
        self.digest = digest


class OCIRepositoryRefPatchDefinition(_serialization.Model):
    """The source reference for the OCIRepository object.

    :ivar tag: The OCI repository image tag name to pull. This defaults to 'latest'.
    :vartype tag: str
    :ivar semver: The semver range used to match against OCI repository tags. This takes precedence
     over tag.
    :vartype semver: str
    :ivar digest: The image digest to pull from OCI repository, the value should be in the format
     ‘sha256:’. This takes precedence over semver.
    :vartype digest: str
    """

    _attribute_map = {
        "tag": {"key": "tag", "type": "str"},
        "semver": {"key": "semver", "type": "str"},
        "digest": {"key": "digest", "type": "str"},
    }

    def __init__(
        self, *, tag: Optional[str] = None, semver: Optional[str] = None, digest: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword tag: The OCI repository image tag name to pull. This defaults to 'latest'.
        :paramtype tag: str
        :keyword semver: The semver range used to match against OCI repository tags. This takes
         precedence over tag.
        :paramtype semver: str
        :keyword digest: The image digest to pull from OCI repository, the value should be in the
         format ‘sha256:’. This takes precedence over semver.
        :paramtype digest: str
        """
        super().__init__(**kwargs)
        self.tag = tag
        self.semver = semver
        self.digest = digest


class OperationStatusResult(_serialization.Model):
    """The current status of an async operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified ID for the async operation.
    :vartype id: str
    :ivar name: Name of the async operation.
    :vartype name: str
    :ivar status: Operation status. Required.
    :vartype status: str
    :ivar properties: Additional information, if available.
    :vartype properties: dict[str, str]
    :ivar error: If present, details of the operation error.
    :vartype error: ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.ErrorDetail
    """

    _validation = {
        "status": {"required": True},
        "error": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "properties": {"key": "properties", "type": "{str}"},
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(
        self,
        *,
        status: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Fully qualified ID for the async operation.
        :paramtype id: str
        :keyword name: Name of the async operation.
        :paramtype name: str
        :keyword status: Operation status. Required.
        :paramtype status: str
        :keyword properties: Additional information, if available.
        :paramtype properties: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.status = status
        self.properties = properties
        self.error: Optional["_models.ErrorDetail"] = None


class PostBuildDefinition(_serialization.Model):
    """The postBuild definitions defining variable substitutions for this Kustomization after
    kustomize build.

    :ivar substitute: Key/value pairs holding the variables to be substituted in this
     Kustomization.
    :vartype substitute: dict[str, str]
    :ivar substitute_from: Array of ConfigMaps/Secrets from which the variables are substituted for
     this Kustomization.
    :vartype substitute_from:
     list[~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.SubstituteFromDefinition]
    """

    _attribute_map = {
        "substitute": {"key": "substitute", "type": "{str}"},
        "substitute_from": {"key": "substituteFrom", "type": "[SubstituteFromDefinition]"},
    }

    def __init__(
        self,
        *,
        substitute: Optional[Dict[str, str]] = None,
        substitute_from: Optional[List["_models.SubstituteFromDefinition"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword substitute: Key/value pairs holding the variables to be substituted in this
         Kustomization.
        :paramtype substitute: dict[str, str]
        :keyword substitute_from: Array of ConfigMaps/Secrets from which the variables are substituted
         for this Kustomization.
        :paramtype substitute_from:
         list[~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.SubstituteFromDefinition]
        """
        super().__init__(**kwargs)
        self.substitute = substitute
        self.substitute_from = substitute_from


class PostBuildPatchDefinition(_serialization.Model):
    """The postBuild definitions defining variable substitutions for this Kustomization after
    kustomize build.

    :ivar substitute: Key/value pairs holding the variables to be substituted in this
     Kustomization.
    :vartype substitute: dict[str, str]
    :ivar substitute_from: Array of ConfigMaps/Secrets from which the variables are substituted for
     this Kustomization.
    :vartype substitute_from:
     list[~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.SubstituteFromPatchDefinition]
    """

    _attribute_map = {
        "substitute": {"key": "substitute", "type": "{str}"},
        "substitute_from": {"key": "substituteFrom", "type": "[SubstituteFromPatchDefinition]"},
    }

    def __init__(
        self,
        *,
        substitute: Optional[Dict[str, str]] = None,
        substitute_from: Optional[List["_models.SubstituteFromPatchDefinition"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword substitute: Key/value pairs holding the variables to be substituted in this
         Kustomization.
        :paramtype substitute: dict[str, str]
        :keyword substitute_from: Array of ConfigMaps/Secrets from which the variables are substituted
         for this Kustomization.
        :paramtype substitute_from:
         list[~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.SubstituteFromPatchDefinition]
        """
        super().__init__(**kwargs)
        self.substitute = substitute
        self.substitute_from = substitute_from


class RepositoryRefDefinition(_serialization.Model):
    """The source reference for the GitRepository object.

    :ivar branch: The git repository branch name to checkout.
    :vartype branch: str
    :ivar tag: The git repository tag name to checkout. This takes precedence over branch.
    :vartype tag: str
    :ivar semver: The semver range used to match against git repository tags. This takes precedence
     over tag.
    :vartype semver: str
    :ivar commit: The commit SHA to checkout. This value must be combined with the branch name to
     be valid. This takes precedence over semver.
    :vartype commit: str
    """

    _attribute_map = {
        "branch": {"key": "branch", "type": "str"},
        "tag": {"key": "tag", "type": "str"},
        "semver": {"key": "semver", "type": "str"},
        "commit": {"key": "commit", "type": "str"},
    }

    def __init__(
        self,
        *,
        branch: Optional[str] = None,
        tag: Optional[str] = None,
        semver: Optional[str] = None,
        commit: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword branch: The git repository branch name to checkout.
        :paramtype branch: str
        :keyword tag: The git repository tag name to checkout. This takes precedence over branch.
        :paramtype tag: str
        :keyword semver: The semver range used to match against git repository tags. This takes
         precedence over tag.
        :paramtype semver: str
        :keyword commit: The commit SHA to checkout. This value must be combined with the branch name
         to be valid. This takes precedence over semver.
        :paramtype commit: str
        """
        super().__init__(**kwargs)
        self.branch = branch
        self.tag = tag
        self.semver = semver
        self.commit = commit


class ServicePrincipalDefinition(_serialization.Model):
    """Parameters to authenticate using Service Principal.

    :ivar client_id: The client Id for authenticating a Service Principal.
    :vartype client_id: str
    :ivar tenant_id: The tenant Id for authenticating a Service Principal.
    :vartype tenant_id: str
    :ivar client_secret: The client secret for authenticating a Service Principal.
    :vartype client_secret: str
    :ivar client_certificate: Base64-encoded certificate used to authenticate a Service Principal.
    :vartype client_certificate: str
    :ivar client_certificate_password: The password for the certificate used to authenticate a
     Service Principal.
    :vartype client_certificate_password: str
    :ivar client_certificate_send_chain: Specifies whether to include x5c header in client claims
     when acquiring a token to enable subject name / issuer based authentication for the Client
     Certificate.
    :vartype client_certificate_send_chain: bool
    """

    _attribute_map = {
        "client_id": {"key": "clientId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "client_secret": {"key": "clientSecret", "type": "str"},
        "client_certificate": {"key": "clientCertificate", "type": "str"},
        "client_certificate_password": {"key": "clientCertificatePassword", "type": "str"},
        "client_certificate_send_chain": {"key": "clientCertificateSendChain", "type": "bool"},
    }

    def __init__(
        self,
        *,
        client_id: Optional[str] = None,
        tenant_id: Optional[str] = None,
        client_secret: Optional[str] = None,
        client_certificate: Optional[str] = None,
        client_certificate_password: Optional[str] = None,
        client_certificate_send_chain: bool = False,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_id: The client Id for authenticating a Service Principal.
        :paramtype client_id: str
        :keyword tenant_id: The tenant Id for authenticating a Service Principal.
        :paramtype tenant_id: str
        :keyword client_secret: The client secret for authenticating a Service Principal.
        :paramtype client_secret: str
        :keyword client_certificate: Base64-encoded certificate used to authenticate a Service
         Principal.
        :paramtype client_certificate: str
        :keyword client_certificate_password: The password for the certificate used to authenticate a
         Service Principal.
        :paramtype client_certificate_password: str
        :keyword client_certificate_send_chain: Specifies whether to include x5c header in client
         claims when acquiring a token to enable subject name / issuer based authentication for the
         Client Certificate.
        :paramtype client_certificate_send_chain: bool
        """
        super().__init__(**kwargs)
        self.client_id = client_id
        self.tenant_id = tenant_id
        self.client_secret = client_secret
        self.client_certificate = client_certificate
        self.client_certificate_password = client_certificate_password
        self.client_certificate_send_chain = client_certificate_send_chain


class ServicePrincipalPatchDefinition(_serialization.Model):
    """Parameters to authenticate using Service Principal.

    :ivar client_id: The client Id for authenticating a Service Principal.
    :vartype client_id: str
    :ivar tenant_id: The tenant Id for authenticating a Service Principal.
    :vartype tenant_id: str
    :ivar client_secret: The client secret for authenticating a Service Principal.
    :vartype client_secret: str
    :ivar client_certificate: Base64-encoded certificate used to authenticate a Service Principal.
    :vartype client_certificate: str
    :ivar client_certificate_password: The password for the certificate used to authenticate a
     Service Principal.
    :vartype client_certificate_password: str
    :ivar client_certificate_send_chain: Specifies whether to include x5c header in client claims
     when acquiring a token to enable subject name / issuer based authentication for the Client
     Certificate.
    :vartype client_certificate_send_chain: bool
    """

    _attribute_map = {
        "client_id": {"key": "clientId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "client_secret": {"key": "clientSecret", "type": "str"},
        "client_certificate": {"key": "clientCertificate", "type": "str"},
        "client_certificate_password": {"key": "clientCertificatePassword", "type": "str"},
        "client_certificate_send_chain": {"key": "clientCertificateSendChain", "type": "bool"},
    }

    def __init__(
        self,
        *,
        client_id: Optional[str] = None,
        tenant_id: Optional[str] = None,
        client_secret: Optional[str] = None,
        client_certificate: Optional[str] = None,
        client_certificate_password: Optional[str] = None,
        client_certificate_send_chain: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_id: The client Id for authenticating a Service Principal.
        :paramtype client_id: str
        :keyword tenant_id: The tenant Id for authenticating a Service Principal.
        :paramtype tenant_id: str
        :keyword client_secret: The client secret for authenticating a Service Principal.
        :paramtype client_secret: str
        :keyword client_certificate: Base64-encoded certificate used to authenticate a Service
         Principal.
        :paramtype client_certificate: str
        :keyword client_certificate_password: The password for the certificate used to authenticate a
         Service Principal.
        :paramtype client_certificate_password: str
        :keyword client_certificate_send_chain: Specifies whether to include x5c header in client
         claims when acquiring a token to enable subject name / issuer based authentication for the
         Client Certificate.
        :paramtype client_certificate_send_chain: bool
        """
        super().__init__(**kwargs)
        self.client_id = client_id
        self.tenant_id = tenant_id
        self.client_secret = client_secret
        self.client_certificate = client_certificate
        self.client_certificate_password = client_certificate_password
        self.client_certificate_send_chain = client_certificate_send_chain


class SubstituteFromDefinition(_serialization.Model):
    """Array of ConfigMaps/Secrets from which the variables are substituted for this Kustomization.

    :ivar kind: Define whether it is ConfigMap or Secret that holds the variables to be used in
     substitution.
    :vartype kind: str
    :ivar name: Name of the ConfigMap/Secret that holds the variables to be used in substitution.
    :vartype name: str
    :ivar optional: Set to True to proceed without ConfigMap/Secret, if it is not present.
    :vartype optional: bool
    """

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "optional": {"key": "optional", "type": "bool"},
    }

    def __init__(
        self, *, kind: Optional[str] = None, name: Optional[str] = None, optional: bool = False, **kwargs: Any
    ) -> None:
        """
        :keyword kind: Define whether it is ConfigMap or Secret that holds the variables to be used in
         substitution.
        :paramtype kind: str
        :keyword name: Name of the ConfigMap/Secret that holds the variables to be used in
         substitution.
        :paramtype name: str
        :keyword optional: Set to True to proceed without ConfigMap/Secret, if it is not present.
        :paramtype optional: bool
        """
        super().__init__(**kwargs)
        self.kind = kind
        self.name = name
        self.optional = optional


class SubstituteFromPatchDefinition(_serialization.Model):
    """Array of ConfigMaps/Secrets from which the variables are substituted for this Kustomization.

    :ivar kind: Define whether it is ConfigMap or Secret that holds the variables to be used in
     substitution.
    :vartype kind: str
    :ivar name: Name of the ConfigMap/Secret that holds the variables to be used in substitution.
    :vartype name: str
    :ivar optional: Set to True to proceed without ConfigMap/Secret, if it is not present.
    :vartype optional: bool
    """

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "optional": {"key": "optional", "type": "bool"},
    }

    def __init__(
        self, *, kind: Optional[str] = None, name: Optional[str] = None, optional: bool = False, **kwargs: Any
    ) -> None:
        """
        :keyword kind: Define whether it is ConfigMap or Secret that holds the variables to be used in
         substitution.
        :paramtype kind: str
        :keyword name: Name of the ConfigMap/Secret that holds the variables to be used in
         substitution.
        :paramtype name: str
        :keyword optional: Set to True to proceed without ConfigMap/Secret, if it is not present.
        :paramtype optional: bool
        """
        super().__init__(**kwargs)
        self.kind = kind
        self.name = name
        self.optional = optional


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or
     ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or
     ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or
         ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or
         ~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TlsConfigDefinition(_serialization.Model):
    """Parameters to authenticate using TLS config for OCI repository.

    :ivar client_certificate: Base64-encoded certificate used to authenticate a client with the OCI
     repository.
    :vartype client_certificate: str
    :ivar private_key: Base64-encoded private key used to authenticate a client with the OCI
     repository.
    :vartype private_key: str
    :ivar ca_certificate: Base64-encoded CA certificate used to verify the server.
    :vartype ca_certificate: str
    """

    _attribute_map = {
        "client_certificate": {"key": "clientCertificate", "type": "str"},
        "private_key": {"key": "privateKey", "type": "str"},
        "ca_certificate": {"key": "caCertificate", "type": "str"},
    }

    def __init__(
        self,
        *,
        client_certificate: Optional[str] = None,
        private_key: Optional[str] = None,
        ca_certificate: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_certificate: Base64-encoded certificate used to authenticate a client with the
         OCI repository.
        :paramtype client_certificate: str
        :keyword private_key: Base64-encoded private key used to authenticate a client with the OCI
         repository.
        :paramtype private_key: str
        :keyword ca_certificate: Base64-encoded CA certificate used to verify the server.
        :paramtype ca_certificate: str
        """
        super().__init__(**kwargs)
        self.client_certificate = client_certificate
        self.private_key = private_key
        self.ca_certificate = ca_certificate


class TlsConfigPatchDefinition(_serialization.Model):
    """Parameters to authenticate using TLS config for OCI repository.

    :ivar client_certificate: Base64-encoded certificate used to authenticate a client with the OCI
     repository.
    :vartype client_certificate: str
    :ivar private_key: Base64-encoded private key used to authenticate a client with the OCI
     repository.
    :vartype private_key: str
    :ivar ca_certificate: Base64-encoded CA certificate used to verify the server.
    :vartype ca_certificate: str
    """

    _attribute_map = {
        "client_certificate": {"key": "clientCertificate", "type": "str"},
        "private_key": {"key": "privateKey", "type": "str"},
        "ca_certificate": {"key": "caCertificate", "type": "str"},
    }

    def __init__(
        self,
        *,
        client_certificate: Optional[str] = None,
        private_key: Optional[str] = None,
        ca_certificate: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_certificate: Base64-encoded certificate used to authenticate a client with the
         OCI repository.
        :paramtype client_certificate: str
        :keyword private_key: Base64-encoded private key used to authenticate a client with the OCI
         repository.
        :paramtype private_key: str
        :keyword ca_certificate: Base64-encoded CA certificate used to verify the server.
        :paramtype ca_certificate: str
        """
        super().__init__(**kwargs)
        self.client_certificate = client_certificate
        self.private_key = private_key
        self.ca_certificate = ca_certificate


class VerifyDefinition(_serialization.Model):
    """Parameters to verify the authenticity of an OCI Artifact.

    :ivar provider: Verification provider name.
    :vartype provider: str
    :ivar verification_config: An object containing trusted public keys of trusted authors.
    :vartype verification_config: dict[str, str]
    :ivar match_oidc_identity: Array defining the criteria for matching the identity while
     verifying an OCI artifact.
    :vartype match_oidc_identity:
     list[~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.MatchOidcIdentityDefinition]
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "verification_config": {"key": "verificationConfig", "type": "{str}"},
        "match_oidc_identity": {"key": "matchOidcIdentity", "type": "[MatchOidcIdentityDefinition]"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        verification_config: Optional[Dict[str, str]] = None,
        match_oidc_identity: Optional[List["_models.MatchOidcIdentityDefinition"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Verification provider name.
        :paramtype provider: str
        :keyword verification_config: An object containing trusted public keys of trusted authors.
        :paramtype verification_config: dict[str, str]
        :keyword match_oidc_identity: Array defining the criteria for matching the identity while
         verifying an OCI artifact.
        :paramtype match_oidc_identity:
         list[~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.MatchOidcIdentityDefinition]
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.verification_config = verification_config
        self.match_oidc_identity = match_oidc_identity


class VerifyPatchDefinition(_serialization.Model):
    """Parameters to verify the authenticity of an OCI Artifact.

    :ivar provider: Verification provider name.
    :vartype provider: str
    :ivar verification_config: An object containing trusted public keys of trusted authors.
    :vartype verification_config: dict[str, str]
    :ivar match_oidc_identity: Array defining the criteria for matching the OIDC identity while
     verifying an OCI artifact.
    :vartype match_oidc_identity:
     list[~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.MatchOidcIdentityPatchDefinition]
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "verification_config": {"key": "verificationConfig", "type": "{str}"},
        "match_oidc_identity": {"key": "matchOidcIdentity", "type": "[MatchOidcIdentityPatchDefinition]"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        verification_config: Optional[Dict[str, str]] = None,
        match_oidc_identity: Optional[List["_models.MatchOidcIdentityPatchDefinition"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Verification provider name.
        :paramtype provider: str
        :keyword verification_config: An object containing trusted public keys of trusted authors.
        :paramtype verification_config: dict[str, str]
        :keyword match_oidc_identity: Array defining the criteria for matching the OIDC identity while
         verifying an OCI artifact.
        :paramtype match_oidc_identity:
         list[~azure.mgmt.kubernetesconfiguration.fluxconfigurations.models.MatchOidcIdentityPatchDefinition]
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.verification_config = verification_config
        self.match_oidc_identity = match_oidc_identity
