/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.match;

import com.thaiopensource.datatype.DatatypeLibraryLoader;
import com.thaiopensource.relaxng.impl.FeasibleTransform;
import com.thaiopensource.relaxng.impl.MatchablePatternImpl;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.SchemaBuilderImpl;
import com.thaiopensource.relaxng.impl.SchemaPatternBuilder;
import com.thaiopensource.relaxng.match.IncorrectSchemaException;
import com.thaiopensource.relaxng.match.MatchablePattern;
import com.thaiopensource.relaxng.parse.IllegalSchemaException;
import com.thaiopensource.relaxng.parse.Parseable;
import com.thaiopensource.relaxng.parse.compact.CompactParseable;
import com.thaiopensource.relaxng.parse.sax.SAXParseable;
import com.thaiopensource.xml.sax.Jaxp11XMLReaderCreator;
import com.thaiopensource.xml.sax.XMLReaderCreator;
import java.io.IOException;
import org.relaxng.datatype.DatatypeLibraryFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MatchablePatternLoader {
    public static final int COMPACT_SYNTAX_FLAG = 1;
    public static final int FEASIBLE_FLAG = 2;

    public MatchablePattern load(InputSource inputSource, ErrorHandler errorHandler, DatatypeLibraryFactory datatypeLibraryFactory, XMLReaderCreator xMLReaderCreator, int n) throws IOException, SAXException, IncorrectSchemaException {
        Parseable parseable;
        SchemaPatternBuilder schemaPatternBuilder = new SchemaPatternBuilder();
        if ((n & 1) != 0) {
            parseable = new CompactParseable(inputSource, errorHandler);
        } else {
            if (xMLReaderCreator == null) {
                xMLReaderCreator = new Jaxp11XMLReaderCreator();
            }
            parseable = new SAXParseable(xMLReaderCreator, inputSource, errorHandler);
        }
        if (datatypeLibraryFactory == null) {
            datatypeLibraryFactory = new DatatypeLibraryLoader();
        }
        try {
            Pattern pattern = SchemaBuilderImpl.parse(parseable, errorHandler, datatypeLibraryFactory, schemaPatternBuilder, false);
            if ((n & 2) != 0) {
                pattern = FeasibleTransform.transform(schemaPatternBuilder, pattern);
            }
            return new MatchablePatternImpl(schemaPatternBuilder, pattern);
        }
        catch (IllegalSchemaException illegalSchemaException) {
            throw new IncorrectSchemaException();
        }
    }
}

