// MIT License
//
// Copyright 2025 Intel Corporation
// Copyright (c) 2018 Chris Holdgraf
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

// doxyrest_code_copy_button.js
// maintained by: kevin.putnam@intel.com
// works with:
//
// * Sphinx version 4.0.2
// * sphinx_copy_button version 0.5.2
//
// The HTML generated by Doxyrest for code blocks differs somewhat
// from standard Sphinx code blocks, so the copybutton extension
// does not work without some adjustments:
//
// 1. must run before copybutton.js
// 2. This script wraps every <pre class="highlight literal-block">
//    in a matching <div class="highlight">
//
// How to use:
// 1. put this file in _static directory (any sub path)
// 2. add to conf.py: app.add_js_file('_static/rest/of/path/doxyrest_code_copy_button.js',priority=300)
//    priority must be lower than default extension value of 500.

const runAtDOMLoaded = cb => {
  if (document.readyState != 'loading') {
    cb()
  } else if (document.addEventListener) {
    document.addEventListener('DOMContentLoaded', cb)
  } else {
    document.attachEvent('onreadystatechange', function() {
      if (document.readyState == 'complete') cb()
    })
  }
}

const doxyrest_copy_buttons = () => {
  // If ClipboardJS hasn't loaded, wait a bit and try again. This
  // happens because we load ClipboardJS asynchronously.
  if (window.ClipboardJS === undefined) {
    setTimeout(doxyrest_copy_buttons, 250)
    return
  }
// Add copybuttons to all of our code cells
const DOXYREST_CODE_SELECTOR = 'pre.highlight.literal-block';
const doxyBlocks = document.querySelectorAll(DOXYREST_CODE_SELECTOR);
doxyBlocks.forEach((doxyBlock, index) => {
  var parent = doxyBlock.parentNode;
  var wrapper = document.createElement('div');
  wrapper.className = 'highlight';
  parent.replaceChild(wrapper,doxyBlock);
  wrapper.appendChild(doxyBlock);
})
}

runAtDOMLoaded(doxyrest_copy_buttons)
